---
description: "Learn more about: Math and Trig functions"
title: "Math and Trig functions (DAX) | Microsoft Docs"
---
# Math and Trig functions

The mathematical functions in Data Analysis Expressions (DAX) are very similar to the Excel mathematical and trigonometric functions. This section lists the mathematical functions provided by DAX.  
  
## In this category 

|Function   |Description  |
|---------|---------|
|[ABS](abs-function-dax.md)       | Returns the absolute value of a number.        |
|[ACOS](acos-function-dax.md)     |  Returns the arccosine, or inverse cosine, of a number.       |
|[ACOSH](acosh-function-dax.md)     | Returns the inverse hyperbolic cosine of a number.        |
|[ACOT](acot-function-dax.md)     | Returns the arccotangent, or inverse cotangent, of a number.        |
|[ACOTH](acoth-function-dax.md)     | Returns the inverse hyperbolic cotangent of a number.       |
|[ASIN](asin-function-dax.md)     |  Returns the arcsine, or inverse sine, of a number.       |
|[ASINH](asinh-function-dax.md)     | Returns the inverse hyperbolic sine of a number.         |
|[ATAN](atan-function-dax.md)     | Returns the arctangent, or inverse tangent, of a number.         |
|[ATANH](atanh-function-dax.md)     | Returns the inverse hyperbolic tangent of a number.        |
|[CEILING](ceiling-function-dax.md)     |  Rounds a number up, to the nearest integer or to the nearest multiple of significance.        |
|[CONVERT](convert-function-dax.md)|Converts an expression of one data type to another. |
|[COS](cos-function-dax.md)     |  Returns the cosine of the given angle.        |
|[COSH](cosh-function-dax.md)     |  Returns the hyperbolic cosine of a number.        |
|[COT](cot-function-dax.md)     |    Returns the cotangent of an angle specified in radians.       |
|[COTH](coth-function-dax.md)     |    Returns the hyperbolic cotangent of a hyperbolic angle.      |
|[CURRENCY](currency-function-dax.md)     | Evaluates the argument and returns the result as currency data type.         |
|[DEGREES](degrees-function-dax.md)     | Converts radians into degrees.        |
|[DIVIDE](divide-function-dax.md)      | Performs division and returns alternate result or BLANK() on division by 0.        |
|[EVEN](even-function-dax.md)       | Returns number rounded up to the nearest even integer.        |
|[EXP](exp-function-dax.md)     |  Returns e raised to the power of a given number.       |
|[FACT](fact-function-dax.md)     |  Returns the factorial of a number, equal to the series 1*2\*3\*...\* , ending in the given number.       |
|[FLOOR](floor-function-dax.md)      |  Rounds a number down, toward zero, to the nearest multiple of significance.         |
|[GCD](gcd-function-dax.md)     |  Returns the greatest common divisor of two or more integers.        |
|[INT](int-function-dax.md)     |  Rounds a number down to the nearest integer.        |
|[ISO.CEILING](iso-ceiling-function-dax.md)      | Rounds a number up, to the nearest integer or to the nearest multiple of significance.        |
|[LCM](lcm-function-dax.md)     | Returns the least common multiple of integers.        |
|[LN](ln-function-dax.md)     | Returns the natural logarithm of a number.        |
|[LOG](log-function-dax.md)     |  Returns the logarithm of a number to the base you specify.        |
|[LOG10](log10-function-dax.md)      |  Returns the base-10 logarithm of a number.         |
|[MOD](mod-function-dax.md)     |  Returns the remainder after a number is divided by a divisor. The result always has the same sign as the divisor.         |
|[MROUND](mround-function-dax.md)     |  Returns a number rounded to the desired multiple.         |
|[ODD](odd-function-dax.md)      | Returns number rounded up to the nearest odd integer.          |
|[PI](pi-function-dax.md)     | Returns the value of Pi, 3.14159265358979, accurate to 15 digits.        |
|[POWER](power-function-dax.md)      |  Returns the result of a number raised to a power.        |
|[QUOTIENT](quotient-function-dax.md)     | Performs division and returns only the integer portion of the division result.        |
|[RADIANS](radians-function-dax.md)      |  Converts degrees to radians.       |
|[RAND](rand-function-dax.md)     |  Returns a random number greater than or equal to 0 and less than 1, evenly distributed.       |
|[RANDBETWEEN](randbetween-function-dax.md)     |  Returns a random number in the range between two numbers you specify.        |
|[ROUND](round-function-dax.md)      | Rounds a number to the specified number of digits.          |
|[ROUNDDOWN](rounddown-function-dax.md)     |  Rounds a number down, toward zero.       |
|[ROUNDUP](roundup-function-dax.md)      |  Rounds a number up, away from 0 (zero).        |
|[SIGN](sign-function-dax.md)      | Determines the sign of a number, the result of a calculation, or a value in a column.        |
|[SIN](sin-function-dax.md)     | Returns the sine of the given angle.          |
|[SINH](sinh-function-dax.md)       | Returns the hyperbolic sine of a number.          |
|[SQRT](sqrt-function-dax.md)      |  Returns the square root of a number.         |
|[SQRTPI](sqrtpi-function-dax.md)     |  Returns the square root of (number * pi).       |
|[TAN](tan-function-dax.md)      |  Returns the tangent of the given angle.         |
|[TANH](tanh-function-dax.md)     |  Returns the hyperbolic tangent of a number.        |
|[TRUNC](trunc-function-dax.md)      | Truncates a number to an integer by removing the decimal, or fractional, part of the number.          |
